<?php

namespace App\Http\Enums\Bill;

enum BillStatusEnum: string
{
    case ACCREDITED = 'Accredited'; // معتمدة
    case DRAFT = 'Draft'; // مسودة
    case CANCELED = 'Canceled'; // ملغي
    case PARTIAL_PAYMENT = 'Partial payment'; // سداد جزئى
    case PAYMENT_COMPLETED = 'Payment completed'; // سداد مكتمل

    public static function getAllStatuses(): array
    {
        return [
            self::ACCREDITED->value,
            self::DRAFT->value,
            self::CANCELED->value,
            self::PARTIAL_PAYMENT->value,
            self::PAYMENT_COMPLETED->value,
        ];
    }

}
