<?php

namespace App\Http\Enums\Branch;


enum BranchTypeEnum: int
{
    case main = 1;
    case sub = 2;


    public static function getValueFromString(?string $name): int
    {
        return match ($name) {
            strtolower(self::main->name) => self::main->value,
            strtolower(self::sub->name) => self::sub->value,
            default => self::sub->value,
        };
    }
}
