<?php

namespace App\Http\Helper;

class AccountHelper
{
    const ACCOUNT_PRODUCTS = 'products';
    const ACCOUNT_PURCHASE_VALUE_TAX = 'purchase_value_tax';
    const ACCOUNT_SUPPLIERS = 'suppliers';
    const ACCOUNT_EARNED_DISCOUNT = 'earned_discount';
    const ACCOUNT_CLIENTS = 'clients';
    const ACCOUNT_PRODUCTS_COSTS = 'products_costs';
    const ACCOUNT_SALES = 'sales';
    const ACCOUNT_SALES_VALUE_TAX = 'sales_value_tax';
    const ACCOUNT_ALLOWED_DISCOUNT = 'allowed_discount';
    const ACCOUNT_OPEN_BALANCE = 'open_balance';
    const ACCOUNT_TREASURIES = 'treasuries';
    const ACCOUNT_BANKS = 'banks';
    const ACCOUNT_NETWORKS = 'networks';
    const ACCOUNT_HOLDERS = 'holders';
    const ACCOUNT_SERVICE_SALES = 'service_sales';
    const ACCOUNT_SERVICE_PRODUCTS_COSTS = 'service_products_costs';
    const ACCOUNT_SUPPLIES_WAREHOUSE = 'supplies_warehouse';
    const ACCOUNT_SERVICE_EXPENSES = 'services_expenses';

    const MODELS = [
        [
            'name' => self::ACCOUNT_SUPPLIERS,
            'label' => [
                'ar' => 'الموردين',
                'en' => 'suppliers account',
            ],
        ],
        [
            'name' => self::ACCOUNT_CLIENTS,
            'label' => [
                'ar' => 'العملاء',
                'en' => 'clients',
            ],
        ],
        [
            'name' => self::ACCOUNT_PRODUCTS,
            'label' => [
                'ar' => 'المنتجات',
                'en' => 'products',
            ],
        ],
        [
            'name' => self::ACCOUNT_OPEN_BALANCE,
            'label' => [
                'ar' => 'الرصيد الافتتاحي',
                'en' => 'open balance',
            ],
        ],
        [
            'name' => self::ACCOUNT_PRODUCTS_COSTS,
            'label' => [
                'ar' => 'تكلفة المنتجات',
                'en' => 'products costs',
            ],
        ],
        [
            'name' => self::ACCOUNT_TREASURIES,
            'label' => [
                'ar' => 'الخزن',
                'en' => 'treasuries',
            ],
        ],
        [
            'name' => self::ACCOUNT_BANKS,
            'label' => [
                'ar' => 'البنوك',
                'en' => 'banks',
            ],
        ],
        [
            'name' => self::ACCOUNT_NETWORKS,
            'label' => [
                'ar' => 'الشبكات',
                'en' => 'networks',
            ],
        ],
        [
            'name' => self::ACCOUNT_HOLDERS,
            'label' => [
                'ar' => 'امناء',
                'en' => 'holders',
            ],
        ],
        [
            'name' => self::ACCOUNT_ALLOWED_DISCOUNT,
            'label' => [
                'ar' => 'خصم مسموح به',
                'en' => 'allowed discount',
            ],
        ],
        [
            'name' => self::ACCOUNT_SALES,
            'label' => [
                'ar' => 'المبيعات',
                'en' => 'sales',
            ],
        ],
        [
            'name' => self::ACCOUNT_SALES_VALUE_TAX,
            'label' => [
                'ar' => 'ضرائب المبيعات',
                'en' => 'sales taxes',
            ],
        ],
        [
            'name' => self::ACCOUNT_PURCHASE_VALUE_TAX,
            'label' => [
                'ar' => 'ضرائب المشتريات',
                'en' => 'purchase taxes',
            ],
        ],
        [
            'name' => self::ACCOUNT_EARNED_DISCOUNT,
            'label' => [
                'ar' => 'خصم مكتسب',
                'en' => 'earned discount',
            ],
        ],
        [
            'name' => self::ACCOUNT_SERVICE_PRODUCTS_COSTS,
            'label' => [
                'ar' => 'تكلفة مستلزمات الخدمات',
                'en' => 'service products costs',
            ],
        ],
        [
            'name' => self::ACCOUNT_SUPPLIES_WAREHOUSE,
            'label' => [
                'ar' => 'مستلزمات الخدمات',
                'en' => 'service supplies',
            ],
        ],
        [
            'name' => self::ACCOUNT_SERVICE_SALES,
            'label' => [
                'ar' => 'الخدمات',
                'en' => 'service sales',
            ],
        ],
        [
            'name' => self::ACCOUNT_SERVICE_EXPENSES,
            'label' => [
                'ar' => 'مصروف الخدمات',
                'en' => 'service expenses',
            ],
        ],

    ];
}
