<?php

namespace App\Http\Helper;

use App\Models\Company;
use Illuminate\Support\Str;

class CompanyHelper
{
    public static function getCompany($request = null)
    {
        $request = request();
        if ($request->user() instanceof Company) {
            return $request->user();
        }
        return $request->user()->company;
    }

    public static function createSecretKey()
    {
        $keyExists = true;
        $key = '';

        while ($keyExists) {
            $randomKey = Str::random(20);
            $formattedKey = implode('-', str_split($randomKey, 4));
            $key = $formattedKey;

            $keyExists = Company::where('secret_key', $key)->exists();
        }

        return $key;
    }
}
