<?php

namespace App\Http\Middleware;

use App\Http\Helper\CompanyHelper;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Auth\Access\AuthorizationException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class AttributeCompany
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (CompanyHelper::getCompany()->id !== $request->route()->attribute->company_id) {
            throw new AuthorizationException;
        }

        if ($request->route()->attribute->model !== $request->model || $request->route()->attribute->type !== $request->type) {
            throw new NotFoundHttpException;
        }

        return $next($request);
    }
}
