<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Company;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;

class CompanySecretKeyAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $apiKey = $request->header('api-key');

        if (!auth('company')->check() || $apiKey) {

            if (!$apiKey) {
                throw ValidationException::withMessages([
                    'api-key' => ['Invalid api key.']
                ]);
            }

            Auth::login(Company::where(['secret_key' => $apiKey])->firstOr(function () {
                throw ValidationException::withMessages([
                    'api-key' => ['Invalid api key.']
                ]);
            }));
        }

        return $next($request);
    }
}
