<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\CountryRepositoryInterface;
use App\Models\Country;

class CountryRepository implements CountryRepositoryInterface
{    
    public function allCountries()
    {
        return Country::whereNull('country_id')->whereNull('city_id')->get();
    }
    
    public function allCities($countryId)
    {
        return Country::where('country_id', $countryId)->get();
    }
    
    public function allArea($cityId)
    {
        return Country::where('city_id', $cityId)->get();
    }

    
}