<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\ProductRepositoryInterface;
use App\Models\Product;

class ProductRepository implements ProductRepositoryInterface
{
    public function getAll()
    {
        $products = Product::with('category')->get();
        return $products;
    }
    public function create($data)
    {
        $product = Product::create($data);

        return $product;
    }
    public function update($data, Product $product)
    {
        $product->update($data);
        return $product;
    }
    public function delete(Product $product)
    {
        $product->delete();
    }
}
