<?php

namespace App\Http\Requests\Api\Account;

use App\Models\Account;
use App\Rules\AccountTypeSameParent;
use App\Rules\AccountValidationType;
use App\Rules\NewAccountValidateType;
use App\Rules\MainAccountValidationRule;
use Illuminate\Foundation\Http\FormRequest;

class StoreAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Account::ROLE, [
            'amount' => 'required|numeric',
            'parent_id' => [
                'nullable',
                'exists:accounts,id',
                new AccountValidationType('main'),
            ],
            'status' => [
                'required',
                'in:main,sub',
                new NewAccountValidateType($this->parent_id)
            ],
            'type' => [
                'required',
                'in:debit,credit',
                new AccountTypeSameParent($this->account->type ?? null)
            ],
        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'active' => $this->active == 'on',
            'amount' => 0,
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
            'description' => [
                'ar' => $this->description_ar,
                'en' => $this->description_en,
            ],
            'parent_id' => $this->account->id ?? null,
        ]);
    }
}
