<?php

namespace App\Http\Requests\Api\Account;

use App\Models\Account;
use App\Rules\NewAccountValidateType;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class UpdateAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Account::ROLE, [
            'status' => [
                'required',
                'in:main,sub',
                new NewAccountValidateType($this->route()->account->parent_id)
            ],
        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'active' => $this->active == 'on',
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
            'description' => [
                'ar' => $this->description_ar,
                'en' => $this->description_en,
            ],
        ]);
    }

    protected function passedValidation()
    {

        if (
            $this->route()->account->status !== $this->status &&
            (
                $this->route()->account->entries()->first() ||
                $this->route()->account->children()->first()
            )
        ) {
            throw ValidationException::withMessages([
                'account' => ['This account have entries or sub accounts, You can not delete it.']
            ]);
        }
    }
}
