<?php

namespace App\Http\Requests\Api\Admin\Package;

use App\Http\Enums\Package\PackageTypeEnum;
use Illuminate\Foundation\Http\FormRequest;

class PackageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'nullable|array',
            'name_ar' => 'required|string',
            'name_en' => 'required|string',
            'price' => 'required|numeric|min:0',
            'type' => 'required|in:' . implode(',', PackageTypeEnum::getTypes()),
            'branches' => 'required|integer|min:0',
            'workers' => 'required|integer|min:0',
            'status' => 'required|in:0,1',
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ]
        ]);
    }
}
