<?php

namespace App\Http\Requests\Api\Client;

use App\Http\Enums\User\UserStatusEnum;
use App\Models\Client;
use Illuminate\Validation\Rule;
use App\Rules\UniqueCompanyPhone;
use App\Rules\UniqueSpecialClient;
use Illuminate\Foundation\Http\FormRequest;

class StoreClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Client::RULES, [
            'phone' => ['required', new UniqueCompanyPhone(Client::class)],
            'email' => 'nullable|email|unique:clients,email',
            'special' => ['nullable', 'boolean', new UniqueSpecialClient],
            // 'status' => ['nullable', Rule::in(UserStatusEnum::class)],
            'status' => ['nullable', Rule::in(array_values(UserStatusEnum::values()))],
        ]);
    }

    public function prepareForValidation()
    {
        $last_code = (int)(Client::withTrashed()->latest()->first()->code ?? "200");
        $this->merge([
            'company_id' => auth()->id(),
            // 'status' => $this->status == 'on',
            'is_client' => $this->is_client == 'on',
            'cache' => $this->cache == 'on',
            'internet' => $this->internet == 'on',
            'fingerprint' => $this->fingerprint == 'on',
            'code' => (string) ($last_code + 1),
            // 'gender' => $this->gender == 1 ? 'male' : 'female',
            'address_line' => ['ar' => $this->address_line_ar, 'en' => $this->address_line_en,],
        ]);
    }
}
