<?php

namespace App\Http\Requests\Api\Company\Absence;

use App\Models\Absence;
use Illuminate\Foundation\Http\FormRequest;

class StoreAbsenceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Absence::RULES, [
            'employee_id' => [
                'required',
                'exists:employees,id,company_id,' . auth()->id() . ",deleted_at,NULL",
                // 'unique:absences,employee_id'
            ],
        ]);
    }
}
