<?php

namespace App\Http\Requests\Api\Company\Bank;

use App\Models\Treasury;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class UpdateBankRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Treasury::RULES, [
            'branch_id' => 'required|exists:branches,id,company_id,' . auth()->id(),
        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
            'status' => $this->status == 'on',
        ]);
    }
}
