<?php

namespace App\Http\Requests\Api\Company\PaymentMethod;

use App\Models\PaymentMethod;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePaymentMethodRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return PaymentMethod::RULES;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ]
        ]);
    }
}
