<?php

namespace App\Http\Requests\Api\Company;

use App\Models\Company;
use Illuminate\Foundation\Http\FormRequest;

class UpdateCompanyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Company::ROLE, [
            'email' => 'required|unique:companies,email,' . $this->company->id,
            'phone' => 'required|unique:companies,phone,' . $this->company->id,
            'logo' => 'nullable|image',
        ]);
    }
}
