<?php

namespace App\Http\Requests\Api\Company\VacationRequest;

use App\Models\VacationRequest;
use App\Rules\VacationRequestAcceptedCheck;
use Illuminate\Foundation\Http\FormRequest;

class ChangeVacationRequestStatusRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'status' => [
                'required',
                'in:' . VacationRequest::VACATION_ACCEPTED . ',' . VacationRequest::VACATION_REJECTED,
                new VacationRequestAcceptedCheck($this->vacationRequest),
            ]
        ];
    }
}
