<?php

namespace App\Http\Requests\Api\Company\VacationRequest;


use App\Models\VacationRequest;
use App\Rules\VacationRequestRule;
use Illuminate\Foundation\Http\FormRequest;

class StoreVacationRequestRequest extends FormRequest
{

    protected $stopOnFirstFailure = true;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(VacationRequest::RULES, [
            'employee_id' => 'required|exists:employees,id,company_id,' . auth()->id() . ',deleted_at,NULL',
            'substitute_employee_id' => [
                'required',
                'exists:employees,id,company_id,' . auth()->id() . ',deleted_at,NULL',
                'different:employee_id'
            ],
            'vacation_id' => [
                'required',
                'exists:vacations,id,company_id,' . auth()->id() . ',deleted_at,NULL',
                new VacationRequestRule($this->employee_id, $this->from, $this->to)
            ],
        ]);
    }
}
