<?php

namespace App\Http\Requests\Api\Product;

use App\Http\Enums\Product\ProductTypeEnum;
use App\Models\Product;
use App\Models\ProductUnit;
use App\Models\ProductWarehouse;
use Illuminate\Foundation\Http\FormRequest;

class StoreProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(
            array_merge(Product::RULES, [
                'product_details.code' => 'required',
                'product_details.type' => 'required|in:' . implode(',', ProductTypeEnum::getTypes()),
            ]),
            array_merge(ProductUnit::RULES, [
                'product_unit.*.barcode' => 'required|string|unique:product_unit,barcode',
            ]),
            ProductWarehouse::RULES
        );
    }

    public function prepareForValidation()
    {
        $last_code = Product::withTrashed()->latest()->first()->code ?? 200;
        $this->merge([
            'product_details' => array_merge($this->input('product_details') ?? [], [
                'code' => $last_code + 1,
                'has_expiry_date' => ($this->product_details['has_expiry_date'] ??  'off') == 'on',
                'name' => [
                    'ar' => $this->product_details['name_ar'] ?? null,
                    'en' => $this->product_details['name_en'] ?? null,
                ],
                'description' => [
                    'ar' => $this->product_details['description_ar'] ?? null,
                    'en' => $this->product_details['description_en'] ?? null,
                ],
            ]),
        ]);
    }
}
