<?php

namespace App\Http\Requests\Api\Service;

use App\Models\Service;
use App\Models\ServicePrice;
use App\Models\ServiceBranch;
use Illuminate\Validation\Rule;
use App\Models\ProductServiceUnit;
use App\Http\Enums\Product\ProductTypeEnum;
use Illuminate\Foundation\Http\FormRequest;

class StoreServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(
            Service::RULES,
            // ServicePrice::RULES,
            ServiceBranch::RULES,
            // ProductServiceUnit::RULES,
            array_merge(ProductServiceUnit::RULES, [
                'products.*.product_id' => [
                    'nullable',
                    Rule::exists('products', 'id')
                        ->whereIn('type', [ProductTypeEnum::SERVICE_TYPE->value, ProductTypeEnum::BOTH_TYPE->value])
                ]
            ]),
            [
                'code' => 'required',
            ]
        );
    }

    public function prepareForValidation()
    {
        $last_code = Service::withTrashed()->latest()->first()->code ?? 200;
        $this->merge([
            'code' => $last_code + 1,
            'status' => $this->status == 'on',
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en
            ],
            'description' => [
                'ar' => $this->description_ar,
                'en' => $this->description_en,
            ],
            'fast_service' => $this->fast_service == 'on',
            'second_employee' => $this->second_employee == 'on',
            'calender_appearance' => $this->calender_appearance == 'on',
            'processing' => $this->processing == 'on',
        ]);
    }
}
