<?php

namespace App\Http\Requests\Api\Supplier;

use App\Models\Address;
use App\Models\Supplier;
use App\Rules\UniqueCompanyPhone;
use Illuminate\Foundation\Http\FormRequest;

class UpdateSupplierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Supplier::RULES, Address::RULES, [
            'phone' => ['required', new UniqueCompanyPhone(Supplier::class, $this->supplier->id)],
        ]);
    }

    public function prepareForValidation()
    {
        $code = $this->supplier->code;
        $this->merge([
            'address_line' => [
                'ar' => $this->address_line_ar,
                'en' => $this->address_line_en
            ],
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en
            ],
            'status' => $this->status == 'on' ? true : false,
            'code' => "$code",
            'company_id' =>auth()->id(),
        ]);
    }
}
