<?php

namespace App\Http\Requests\Delivery;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UpdateDeliveryRequest extends FormRequest
{
    public function rules()
    {
        return
            [
                'name' => 'required|string',

                'phone' => 'required|string|unique:deliveries,phone,' . $this->route()->delivery->id,
                'branch_id' => [
                    'bail',
                    Rule::requiredIf(function () {
                        return $this->route()->delivery->type != 'inner';
                    }),
                    'exists:branches,id,deleted_at,NULL',
                ],
            ];
    }

    public function validated(): array
    {
        if ($this->route('delivery')->type != 'inner') {
            return array_merge(parent::validated(), [
                'branch_id' => null,
            ]);
        }
        return parent::validated();
    }
}
