<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BillProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'product' => new ProductResource($this->whenLoaded('product')),
            'unit' => $this->whenLoaded('unit', function () {
                return [
                    'unit_id' => $this->unit->id,
                    'unit_name' => $this->unit->name,
                ];
            }),
            // 'unit' => new UnitResource($this->whenLoaded('unit')),
            'quantity' => $this->quantity,
            "price" => number_format($this->price, 2),
            'discount_type' => $this->discount_type,
            "discount" => number_format($this->discount, 2),
            'tax_included' => $this->tax_included ? 1 : 0,
            'tax' => new TaxResource($this->whenLoaded('tax')),
        ];
    }
}
