<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BillServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'discount_type' => $this->discount_type,
            'discount_amount' => $this->discount_amount,
            'date' => $this->date,
            'quantity' => $this->quantity,
            'starts_at' => $this->starts_at,
            'service' => ServiceResource::make($this->whenLoaded('service')),
            'branch' => BranchResource::make($this->whenLoaded('branch')),
            'bill' => BillResource::make($this->whenLoaded('bill')),
        ];
    }
}
