<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BranchResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'],
            'name_en' => $this->getTranslations('name')['en'],
            'phone_1' => $this->phone_1,
            'phone_2' => $this->phone_2,
            'email' => $this->email,
            'website' => $this->website,
            // 'manager_fname' => $this->manager_fname,
            // 'manager_lname' => $this->manager_lname,
            // 'gender' => $this->gender,
            // 'home_service' => $this->home_service,
            // 'beauty_expert' => $this->beauty_expert,
            'type' => $this->type?->name,
            'delivers' => $this->delivers,
            'number_of_employees' => $this->number_of_employees,
            'address' => new AddressResource($this->whenLoaded('address')),
            'group_settings_id' => $this->group_settings_id,
            // 'job_types' => JobTypeResource::collection($this->whenLoaded('jobTypes')),
            'employees' => EmployeeResource::collection($this->whenLoaded('employees')),
            'warehouses' => WarehouseResource::collection($this->whenLoaded('warehouses')),
            'deliveries' => DeliveryResource::collection($this->whenLoaded('deliveries')),
            'deliveries' => DeliveryResource::collection($this->whenLoaded('deliveries')),
            'sell_natures' => $this->whenLoaded('company', function () {
                return SellNatureResource::collection($this->company->sellNatures);
            }),
        ];
    }
}
