<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "type" => $this->type,
            "name" => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'],
            'name_en' => $this->getTranslations('name')['en'],
            "description" => $this->description,
            "description_ar" => $this->getTranslations('description')['ar'],
            "description_en" => $this->getTranslations('description')['en'],
            "internet_description" => $this->internet_description,
            "status" => $this->status,
            "fast" => $this->fast,
        ];
    }
}
