<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CurrencyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'],
            'name_en' => $this->getTranslations('name')['en'],
            'code' => $this->code,
            'code_ar' => $this->getTranslations('code')['ar'],
            'code_en' => $this->getTranslations('code')['en'],
            'exchange_rate' => $this->exchange_rate ?? 0,
            'type' => $this->type,
        ];
    }
}
