<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EntryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'status' => $this->status,
            'journal' => JournalResource::make($this->whenLoaded('journal')),
            'type' => $this->whenLoaded('type', function () {
                $resourceClass = app($this->type_type)->resolveResource();
                return new $resourceClass($this->type);
            }),
            'account' => new AccountResource($this->whenLoaded('account')),
            'amount' => number_format($this->amount, 2),
        ];
    }
}
