<?php

namespace App\Http\Resources;

use App\Http\Resources\AccountModelResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ModelGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'models' => AccountModelResource::collection($this->whenLoaded('mainModels')),
        ];
    }
}
