<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'ref_id' => $this->ref_id,
            'bill_type' => $this->bill_type,
            'note' => $this->note,
            'total' => $this->total,
            'subtotal' => $this->subtotal,
            'tax' => $this->tax,
            'discount' => $this->discount,
            'paid_amount' => $this->paid_amount,
            'user_id' => $this->user_id,
            'cart_id' => $this->cart_id,
            'created_at' => $this->created_at,
            'status' => strtolower($this->status->name),
            'user' => UserOrderResource::make($this->whenLoaded('user')),
            'items' => ItemOrderResource::collection($this->whenLoaded('items')),
        ];
    }
}
