<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductWarehouseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "product_id" => $this->product_id,
            "warehouse_id" => $this->warehouse_id,
            "warehouse" => $this->whenLoaded('warehouse', function () {
                return $this->warehouse->name;
            }),
            'product' => new ProductResource($this->whenLoaded('product')),
            "min_quantity" => $this->min_quantity,
            "max_quantity" => $this->max_quantity,
            "quantity" => $this->quantity,
            "price" => number_format($this->price, 2),
            "open_balance_price" => number_format($this->open_balance_price, 2),
            "open_balance_quantity" => $this->open_balance_quantity,
        ];
    }
}
