<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class VacationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'],
            'name_en' => $this->getTranslations('name')['en'],
            'maximum_balance' => $this->maximum_balance,
            'before_request' => $this->before_request,
            'maximum_days_request' => $this->maximum_days_request,
            'all' => $this->all ? 'on' : 'off',
            'status' => $this->status ? 'on' : 'off',
            'year_to_year' => $this->year_to_year ? 'on' : 'off',
            'deducted_weekly' => $this->deducted_weekly ? 'on' : 'off',
        ];
    }
}
