<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class WarehouseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            'code' => $this->code,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'],
            'name_en' => $this->getTranslations('name')['en'],
            'status' => $this->status,
            'type' => $this->type,
            'purpose' => $this->purpose,
            'company_id' => $this->company_id,
            'address' => $this->address,
            'balance' => number_format($this->products_sum_value / 100, 2),
            'branches' => BranchResource::collection($this->whenLoaded('branches')),
            'products' => ProductWarehouseResource::collection($this->whenLoaded('products')),
        ];
    }
}
