<?php

namespace App\Http\Services\Account;

use App\Models\Journal;
use App\Models\Product;
use App\Models\ProductWarehouse;
use App\Http\Helper\AccountHelper;

class OpenBalanceService
{
    public Product $product;

    const NAME = Journal::AUTO_TYPE;
    const DESCRIPTION = "Open Balance Description";

    public function __construct(Product $product)
    {
        $this->product = $product;
    }

    public function updateQuantity($quantity, $price)
    {
        $quantity = $this->product->units->first()->conversion_factor * $quantity;
        $this->product->warehouses->first()->update([
            'value' => ($quantity * $price),
            'quantity' => $quantity,
            'price' => $price,
            'open_balance_quantity' => $quantity,
            'open_balance_price' => $price,
        ]);
        return $this;
    }

    public static function createJournal($total, $product, $warehouse)
    {
        JournalService::createJournal(
            date: now(),
            type: Journal::AUTO_TYPE,
            source: "Open Balance",
            description: self::DESCRIPTION,
            file: null,
            employee: null,
            status: true,
            debit: [
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PRODUCTS),
                    'type' => [
                        'type' => Product::class,
                        'id' => $product->id,
                    ],
                    'amount' => $total,
                    'entry_type' => "debit",
                ],
            ],
            credit: [
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_OPEN_BALANCE),
                    'type' => [
                        'type' => ProductWarehouse::class,
                        'id' => $warehouse->id,
                    ],
                    'amount' => $total,
                    'entry_type' => "credit",
                ],
            ],
            journalable: $product
        );
    }
}
