<?php

namespace App\Http\Services\Bill;

use App\Models\Journal;
use App\Http\Enums\Bill\BillEnum;
use App\Trait\BillJournalEntryTrait;
use App\Http\Services\Bill\BillService;

class BillJournalEntryService
{
    use BillJournalEntryTrait;

    private $billService;

    const SALES_NAME = Journal::AUTO_TYPE;
    const SALES_DESCRIPTION = "Sales Bill Description";
    const PURCHASE_NAME = Journal::AUTO_TYPE;
    const PURCHASE_DESCRIPTION = "Purchase Bill Description";

    public function __construct(BillService $billService)
    {
        $this->billService = $billService;
    }

    public function createJournalEntries()
    {
        if ($this->billService->bill->type === BillEnum::sales->value) {
            $this->createSalesJournalEntries();
        } else {
            $this->createPurchaseJournalEntries();
        }
    }
}
