<?php

namespace App\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class CompanyMainAccounts
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $main_accounts = [
            [
                'name' => [
                    'ar' => 'الاصول',
                    'en' => 'Assets',
                ],
                'description' => [
                    'ar' => 'وصف للاصول',
                    'en' => 'Assets Description',
                ],
                'code' => '1',
                'type' => 'debit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
            ],
            [
                'name' => [
                    'ar' => 'الخصوم',
                    'en' => 'liabilities',
                ],
                'description' => [
                    'ar' => 'وصف الخصوم',
                    'en' => 'liabilities Description',
                ],
                'code' => '2',
                'type' => 'credit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
            ],
            [
                'name' => [
                    'ar' => 'المصروفات',
                    'en' => 'Expenses',
                ],
                'description' => [
                    'ar' => 'وصف المصروفات',
                    'en' => 'Expenses Description',
                ],
                'code' => '3',
                'type' => 'debit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
            ],
            [
                'name' => [
                    'ar' => 'الايرادات',
                    'en' => 'revenues',
                ],
                'description' => [
                    'ar' => 'وصف الايرادات',
                    'en' => 'revenues Description',
                ],
                'code' => '4',
                'type' => 'credit',
                'status' => 'main',
                'active' => true,
                'amount' => 0,
            ],

        ];
        foreach($main_accounts as $account)
        {
            $event->company->accounts()->create($account);
        }
    }
}
