<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Translatable\HasTranslations;

class AttendanceMethod extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'short_code' => 'required|string',
        'color' => 'required|string',
    ];

    protected $fillable = [
        'company_id',
        'name',
        'short_code',
        'color',
        'days',
    ];

    protected $translatable = [
        'name',
    ];

    protected $casts = [
        'days' => 'json',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }
}
