<?php

namespace App\Models;

use App\Http\Helper\AccountHelper;
use App\Http\Resources\BankResource;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use App\Http\Services\Account\AccountService;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Bank extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'status' => 'required|boolean',
    ];
    protected $fillable = [
        'company_id',
        'branch_id',
        'name',
        'status',
    ];

    protected $translatable = [
        'name',
    ];

    public function resolveResource()
    {
        return BankResource::class;
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function account()
    {
        return AccountService::getAccountForModel(AccountHelper::ACCOUNT_BANKS);
    }
}
