<?php

namespace App\Models;

use App\Http\Enums\Bound\BoundTypeEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Bound extends Model
{
    use HasFactory, SoftDeletes;

    const FILE_PATH = 'uploads/company/bounds';

    protected $fillable = [
        'type', // Payments - Receivables
        'date',
        'description',
        // 'tax_id',
        'company_id',
        'file',
        'payment_method_id', // use in payment method
        'payment_type', // use in payment method
        'payment_id', // use in payment method
        'resource', // use in payment method
        'value', // use in payment method
        'ref_number', // used in Payments type
        'tax_number', // used in Payments type supplier type
        'entry_type',
        'entry_id',
    ];

    protected $casts = [
        'type' => BoundTypeEnum::class,
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function payment()
    {
        return $this->morphTo('payment');
    }

    public function entry()
    {
        return $this->morphTo('entry');
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }

    // public function tax()
    // {
    //     return $this->belongsTo(Tax::class);
    // }

    public function journals()
    {
        return $this->morphMany(Journal::class, 'journalable');
    }
}
