<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Career extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    protected $table = 'careers_sections';

    const CAREER_TYPE = 1;

    const RULES = [
        'name' => 'nullable',
        'type' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
    ];

    protected $fillable = [
        'company_id',
        'name',
        'type',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
