<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class CompanyCurrency extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULE = [
        'name' => 'nullable',
        'code' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'code_ar' => 'required|string',
        'code_en' => 'required|string',
        'exchange_rate' => 'required|numeric',
    ];


    protected $fillable = [
        'name',
        'code',
        'type',
        'exchange_rate',
    ];

    protected $translatable = [
        'name',
        'code',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
