<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class CompanyUnit extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULE = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
    ];

    protected $fillable = [
        'name',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function productServiceUnits()
    {
        return $this->hasMany(ProductServiceUnit::class, 'company_unit_id');
    }
}
