<?php

namespace App\Models;

use App\Http\Helper\AccountHelper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Journal extends Model
{
    use HasFactory;

    const UPLOADED_FILES = 'uploads/journals';
    const AUTO_TYPE = 'automatic by the system';
    const MANUAL_TYPE = 'manual by the user';

    protected $fillable = [
        'date',
        'company_id',
        'type',
        'source',
        'description',
        'file',
        'employee_id',
        'status',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function entries()
    {
        return $this->hasMany(JournalEntry::class);
    }

    public function journalable()
    {
        return $this->morphTo();
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function scopeBillOfProduct($query, $product)
    {
        return
            $query->whereHasMorph('journalable', [Bill::class], function ($query) use ($product) {
                $query->whereHas('billProducts', function ($query) use ($product) {
                    $query->where('product_id', $product->id)
                        ->with('billProducts');
                });
            })
            ->whereHas('entries', function ($query) {
                return $query->whereHas('account', function ($query) {
                    return $query->whereHas('model', function ($query) {
                        return $query->where('name', AccountHelper::ACCOUNT_PRODUCTS);
                    });
                });
            });
    }
}
