<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class PaymentTerm extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    const RULES = [
        'name' => 'nullable',
        'description' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'description_ar' => 'required|string',
        'description_en' => 'required|string',
        'number_of_days' => 'required',
    ];

    protected $fillable = [
        'company_id',
        'name',
        'description',
        'number_of_days',
    ];

    protected $translatable = [
        'name',
        'description',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
