<?php

namespace App\Models;

use App\Http\Enums\Product\ProductTypeEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductServiceUnit extends Model
{
    use HasFactory;

    const RULES = [
        'products' => 'nullable',
        'products.*.product_id' => 'required|exists:products,id',
        'products.*.company_unit_id' => 'required|exists:company_units,id',
        'products.*.percentage' => 'required|numeric|min:0.1|max:100',
    ];

    protected $fillable = [
        'product_id',
        'service_id',
        'company_unit_id',
        'percentage',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function unit()
    {
        return $this->belongsTo(CompanyUnit::class);
    }

    public function getPercentageAttribute($value)
    {
        return $value / 100;
    }

    public function setPercentageAttribute($value)
    {
        $this->attributes['percentage'] = $value * 100;
    }
}
