<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ProductUnit extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'product_unit';

    protected $fillable = [
        'unit_id',
        'product_id',
        'main',
        'virtual_sale',
        'virtual_buying',
        'conversion_factor',
        'purchasing_price',
        'selling_price',
        'barcode',
        'tax_id',
    ];

    const RULES = [
        'product_unit' => 'nullable|array',
        'product_unit.*.unit_id' => 'required|exists:company_units,id',
        'product_unit.*.main' => 'required|in:on,off',
        'product_unit.*.virtual_sale' => 'required|in:on,off',
        'product_unit.*.virtual_buying' => 'required|in:on,off',
        'product_unit.*.conversion_factor' => 'required|integer|min:1',
        'product_unit.*.purchasing_price' => 'required|numeric',
        'product_unit.*.selling_price' => 'required|numeric',
        'product_unit.*.barcode' => 'required|string|unique:product_unit',
    ];

    public function unit()
    {
        return $this->belongsTo(CompanyUnit::class, 'unit_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
