<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductUnitWarehouse extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_warehouse_id',
        'product_unit_id',
        'quantity',
    ];

    public function productWarehouse()
    {
        return $this->belongsTo(ProductWarehouse::class, 'product_warehouse_id');
    }

    public function productUnit()
    {
        return $this->belongsTo(ProductUnit::class, 'product_unit_id');
    }
}
