<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Http\Resources\ProductWarehouseResource;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class ProductWarehouse extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'warehouse_id',
        'product_id',
        'min_quantity',
        'max_quantity',
        'value',
        'price',
        'quantity',
        'open_balance_price',
        'open_balance_quantity',
    ];

    const RULES = [
        'product_warehouse' => 'nullable|array',
        'product_warehouse.*.warehouse_id' => 'required|exists:warehouses,id',
        'product_warehouse.*.min_quantity' => 'required|numeric',
        'product_warehouse.*.max_quantity' => 'required|numeric',
    ];

    public function resolveResource()
    {
        return ProductWarehouseResource::class;
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class, 'warehouse_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unit()
    {
        return $this->belongsTo(CompanyUnit::class, 'unit_id');
    }

    public function getPriceAttribute($value)
    {
        return $value / 100;
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = $value * 100;
    }

    public function getOpenBalancePriceAttribute($value)
    {
        return $value / 100;
    }

    public function setOpenBalancePriceAttribute($value)
    {
        $this->attributes['open_balance_price'] = $value * 100;
    }

    public function getValueAttribute($value)
    {
        return $value / 100;
    }

    public function setValueAttribute($value)
    {
        $this->attributes['value'] = $value * 100;
    }
}
