<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Tax extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required|string',
        'name_en' => 'required|string',
        'rate' => 'required',
    ];

    protected $fillable = [
        'company_id',
        'name',
        'rate',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
