<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Translatable\HasTranslations;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasTranslations, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'phone',
        'birth_date',
        'id_type',
        'id_no',
        'attend_method_id',
        'Job_id',
        'address_id',
        'hired_at',
        'status',
        'online_booking',
        'appear_in_calendar',
        'has_imprint',
        'fingerprint_code'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    public $translatable = [
        'name'
    ];

    function address()
    {
        return $this->belongsTo(Address::class);
    }

    public function job()
    {
        return $this->belongsTo(Job::class);
    }


    public function branches()
    {
        return $this->morphToMany(Branch::class, 'branchable');
    }

    public function attendMethod()
    {
        return $this->belongsTo(AttendMethods::class, 'attend_method_id');
    }

    public function attendances()
    {
        return $this->hasMany(EmployeeAttendance::class, 'attend_method_id');
    }
}
